/************************************************************
 **
 ** pic_opco.h : PIC opcode declarations
 **
 ** Copyright (c) 2004-2005, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#ifndef pic_opco_h__
#define pic_opco_h__

typedef enum {
  pic_opcode_org,    /* ORG xxxx */
  pic_opcode_end,    /* END      */
  pic_opcode_none,   /* no code here */
  /* pic_instr_append_f_d   */
  /* pic_instr_append_reg_d */
  pic_opcode_addwf,  /* f  + w --> d                 */
  pic_opcode_andwf,  /* f  & w --> d                 */
  pic_opcode_xorwf,  /* f  ^ w --> d                 */
  pic_opcode_iorwf,  /* f  | w --> d                 */
  pic_opcode_subwf,  /* f  - w --> d                 */
  pic_opcode_comf,   /* ~f     --> d                 */
  pic_opcode_decf,   /* f - 1  --> d                 */
  pic_opcode_decfsz, /* f - 1  --> d, skip next if 0 */
  pic_opcode_incf,   /* f + 1  --> d                 */
  pic_opcode_incfsz, /* f + 1  --> d, skip next if 0 */
  pic_opcode_rlf,    /* f << 1 --> d                 */
  pic_opcode_rrf,    /* f >> 1 --> d                 */
  pic_opcode_movf,   /* f      --> d                 */
  pic_opcode_swapf,  /* swap nibbles in f --> d      */
  /* pic_instr_append_f   */
  /* pic_instr_append_reg */
  pic_opcode_clrf,   /* f = 0                        */
  pic_opcode_movwf,  /* w      --> f                 */
  /* pic_instr_append */
  pic_opcode_nop,    /*                              */
  pic_opcode_clrw,   /* w = 0     */
  pic_opcode_retfie, /* return from interrupt */
  pic_opcode_ret,    /* return */
  pic_opcode_sleep,
  pic_opcode_clrwdt,
  pic_opcode_option, /* w --> option */
  /* pic_instr_append_f_b      */
  /* pic_instr_append_reg_flag */
  /* pic_instr_append_f_bn     */
  /* pic_instr_append_reg_bn   */
  pic_opcode_bcf,    /* f, b -- bit clear */
  pic_opcode_bsf,    /* f, b -- bit set   */
  pic_opcode_btfsc,  /* f, b -- bit test, skip next if clear */
  pic_opcode_btfss,  /* f, b -- bit test, skip next if set   */
  /* pic_instr_append_w_k  */
  /* pic_instr_append_w_kn */
  pic_opcode_addlw,  /* w = k + w */
  pic_opcode_andlw,  /* w = k & w */
  pic_opcode_iorlw,  /* w = k | w */
  pic_opcode_movlw,  /* w = k     */
  pic_opcode_sublw,  /* w = k - w */
  pic_opcode_xorlw,  /* w = k ^ w */
  pic_opcode_retlw,
  pic_opcode_tris,   /* w --> tris; k must be 6; backward compat only! */
  /* use pic_instr_append_n */
  pic_opcode_call,   /* call n */
  pic_opcode_goto,   /* goto n */
  /* pseudo-ops to make life easier, translation in comments */
  pic_opcode_datalo_set, /* bsf _status, _rp0 */
  pic_opcode_datalo_clr, /* bcf _status, _rp0 */
  pic_opcode_datahi_set, /* bsf _status, _rp1 */
  pic_opcode_datahi_clr, /* bcf _status, _rp1 */
  pic_opcode_irp_set,    /* bsf _status, _irp */
  pic_opcode_irp_clr,    /* bcf _status, _irp */
  pic_opcode_branchlo_set, /* bsf _pclath, 3 */
  pic_opcode_branchlo_clr, /* bcf _pclath, 3 */
  pic_opcode_branchlo_nop, /* nop */
  pic_opcode_branchhi_set, /* bsf _pclath, 4 */
  pic_opcode_branchhi_clr, /* bcf _pclath, 4 */
  pic_opcode_branchhi_nop, /* nop */
  pic_opcode_db            /* db yy,xx */
} pic_opcode_t;

typedef enum {
  pic_optype_none = 0, /* no parameters */
  pic_optype_f,        /* opdst = none, val = f, val2 = none, label = none */
  pic_optype_f_d,      /* opdst = w/f,  val = f, val2 = none, label = none */
  pic_optype_f_b,      /* opdst = none, val = f, val2 = bit,  label = none */
  pic_optype_n,        /* opdst = none, val = none, val2 = #, label = none */
  pic_optype_k,        /* opdst = none, val = none, val2 = none, label = k */
  pic_optype_tris,     /* opdst = none, val = none, val2 = t, label = none */
  pic_optype_db
#if 0
  pic_optype_macro,
#endif
} pic_optype_t;

typedef enum {
  pic_opdst_none, /* no dst */
  pic_opdst_w,
  pic_opdst_f
} pic_opdst_t;

#endif /* pic_opco_h__ */

