#include <stdio.h>
#include <stdlib.h>

typedef enum {
  JAL_TYPE_UNIVERSAL,
  JAL_TYPE_BIT,
  JAL_TYPE_BYTE,
  JAL_TYPE_SBYTE,
  JAL_TYPE_WORD,
  JAL_TYPE_SWORD,
  JAL_TYPE_DWORD,
  JAL_TYPE_SDWORD,
  JAL_TYPE_CT
} jal_type_t;

static const char *jal_type_to_str(jal_type_t type)
{
  const char *str;

  str = "";
  switch (type) {
    case JAL_TYPE_UNIVERSAL:                 break;
    case JAL_TYPE_BIT:       str = "bit";    break;
    case JAL_TYPE_BYTE:      str = "byte";   break;
    case JAL_TYPE_SBYTE:     str = "sbyte";  break;
    case JAL_TYPE_WORD:      str = "word";   break;
    case JAL_TYPE_SWORD:     str = "sword";  break;
    case JAL_TYPE_DWORD:     str = "dword";  break;
    case JAL_TYPE_SDWORD:    str = "sdword"; break;
  }
  return str;
}

typedef enum {
  JAL_BANK_0,
  JAL_BANK_CT,
} jal_bank_t;

typedef enum {
  JAL_QUALIFIER_CONST,
  JAL_QUALIFIER_NONE,
  JAL_QUALIFIER_VOLATILE,
  JAL_QUALIFIER_CT
} jal_qualifier_t;

static const char *jal_qualifier_to_str(jal_qualifier_t qual)
{
  const char *str;

  str = "";
  switch (qual) {
    case JAL_QUALIFIER_CONST:     str = "const"; break;
    case JAL_QUALIFIER_NONE:
    case JAL_QUALIFIER_VOLATILE:
  }
  return str;
}

typedef struct {
  jal_type_t      type;
  jal_bank_t      bank;
  jal_qualifier_t qualifier;
} jal_val_descr_t;

static void create(const jal_val_descr_t *dst,
    const jal_val_descr_t *val1,
    const jal_val_descr_t *val2)
{
  printf("include c16f877.jal\n"
         "\n");
  
}

static void doit(jal_val_descr_t *dst, 
    jal_val_descr_t *val1, 
    jal_val_descr_t *val2)
{
  jal_val_descr_t descr;

  for (descr.type = (0 == dst) ? JAL_TYPE_BIT : JAL_TYPE_UNIVERSAL;
       descr.type < JAL_TYPE_CT;
       descr.type++) {
    for (descr.bank = JAL_BANK_0;
         descr.bank < JAL_BANK_CT;
         descr.bank++) {
      for (descr.qualifier = 
            (0 == dst) ? JAL_QUALIFIER_NONE : JAL_QUALIFIER_CONST;
          descr.qualifier < JAL_QUALIFIER_CT;
          descr.qualifier++) {
        if (!dst) {
          doit(&descr, 0, 0);
        } else if (!val1) {
          doit(dst, &descr, 0);
        } else {
          execute(dst, val1, &descr);
        }
      }
    }
  }
}

int main(int argc, char **argv)
{
  jal_type_t jtype;

  for (jtype = JAL_TYPE_UNIVERSAL;
       jtype < JAL_TYPE_CT;
       jtype++) {
    jal_qualifier_t jqual;

    for (jqual = JAL_QUALIFIER_NONE;
         jqual < JAL_QUALIFIER_CT;
         jqual++) {
ZZ      printf("include c16f877\n");


    }
  }
}

