/************************************************************
 **
 ** bsc_file.h : BSC file structure declarations
 **
 ** Copyright (c) 2004, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#ifndef bsc_file_h__
#define bsc_file_h__

#include "pfile.h"
#include "label.h"

#define BSC_IR_NAME_SZ_MAX 32

/* these help find common errors */
typedef enum bsc_file_flag_ {
  bsc_file_flag_adc_config,       /* adc is configured      */
  bsc_file_flag_adc_start,        /* adc is started         */
  bsc_file_flag_interrupt_enable, /* interrupt_enable used  */
  bsc_file_flag_timer_config,     /* timer is configured    */
  bsc_file_flag_timer_start,      /* timer is started       */
  bsc_file_flag_usart_config_rx,  /* usart rx is configured */
  bsc_file_flag_usart_config_tx   /* usart tx is configured */
} bsc_file_flag_t;

typedef unsigned bsc_pass_t;

/* isr types */
typedef enum bsc_isr_type_ {
  bsc_isr_type_first,
  bsc_isr_type_timer = bsc_isr_type_first, /* this MUST be first */
  bsc_isr_type_adc,
  bsc_isr_type_pwm,
  bsc_isr_type_rx,
  bsc_isr_type_tx,
  bsc_isr_type_rb,
  bsc_isr_type_user,
  bsc_isr_type_ct
} bsc_isr_type_t;

result_t bsc_file_open(pfile_t *pf);
void     bsc_file_close(pfile_t *pf);

void     bsc_source_process(pfile_t *pf);
void     bsc_file_process(pfile_t *pf);

result_t bsc_file_isr_get(pfile_t *pf, bsc_isr_type_t isr, 
    boolean_t alloc, label_t *dst);
label_t  bsc_file_isr_next_get(pfile_t *pf, bsc_isr_type_t type);

void        bsc_file_pass_reset(pfile_t *pf);
bsc_pass_t  bsc_file_pass_get(pfile_t *pf);

size_t      bsc_file_strid_next(pfile_t *pf);
void        bsc_file_log_unavail(pfile_t *pf, const char *cmd);

boolean_t   bsc_file_flag_test(const pfile_t *pf, bsc_file_flag_t flag);
void        bsc_file_flag_set(pfile_t *pf, bsc_file_flag_t flag);
void        bsc_file_flag_clr(pfile_t *pf, bsc_file_flag_t flag);

#endif /* bsc_file_h__ */

