/**********************************************************
 **
 ** jal_op.c : JAL operator precedence declarations
 **
 ** Copyright (c) 2005, Kyle A. York
 ** All rights reserved
 **
 ***********************************************************/
#include "../libcore/operator.h"

operator_priority_t operator_priority_get(operator_t op)
{
  operator_priority_t pr;

  pr = 0;
  switch (op) {
    case operator_null:        pr = 0; break; 
    case operator_reference:   pr = 16; break;
    case operator_logical:
    case operator_notl:
    case operator_neg:
    case operator_cmpb:        pr = 15; break;
    case operator_mul:
    case operator_div:
    case operator_mod:         pr = 14; break;
    case operator_add:
    case operator_sub:         pr = 13; break;
    case operator_shift_left: 
    case operator_shift_right:
    case operator_shift_right_arithmetic:
    case operator_lt:
    case operator_le:
    case operator_eq:
    case operator_ne:
    case operator_ge:
    case operator_gt:          pr = 11; break;
    case operator_andl:
    case operator_orl:
    case operator_andb:
    case operator_orb:
    case operator_xorb:        pr = 10; break;
    case operator_incr:
    case operator_decr:
    case operator_assign:      pr = 0; break;
  }
  return pr;
}

