/************************************************************
 **
 ** operator.h : operator declarations
 **
 ** Copyright (c) 2004-2005, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#ifndef operator_h__
#define operator_h__

#include "variable.h"

typedef enum operator_ {
  operator_null,         /* no operation   */
  /* basic operations */
  operator_add,
  operator_sub,
  operator_mul,
  operator_div,
  operator_mod,
  /* relationals      */
  operator_lt,
  operator_le,
  operator_eq,
  operator_ne,
  operator_ge,
  operator_gt,
  /* logicals         */
  operator_andl,
  operator_orl,
  operator_notl, /* unary */
  /* bits             */
  operator_andb,
  operator_orb,
  operator_xorb,
  operator_cmpb, /* unary */
  /* misc */
  operator_assign,  /* unary */
  operator_neg,     /* unary */
  operator_incr,    /* unary */
  operator_decr,    /* unary */
  operator_shift_left,
  operator_shift_right,
  operator_shift_right_arithmetic, /* preserve the sign bit */
  operator_logical,  /* unary : convert a value to either 0 or 1 */
  operator_reference /* unary : return the address of a variable or label */
} operator_t;

#define operator_ct ((operator_t) (operator_reference + 1))

typedef unsigned short operator_priority_t;

operator_priority_t operator_priority_get(operator_t op);
boolean_t           operator_is_binary(operator_t op);
boolean_t           operator_is_unary(operator_t op);
boolean_t           operator_is_assign(operator_t op);
boolean_t           operator_is_logical(operator_t op);
boolean_t           operator_is_relation(operator_t op);
boolean_t           operator_is_commutative(operator_t op);
#endif /* operator_h__ */

