/************************************************************
 **
 ** array.h : array definitions
 **
 ** Copyright (c) 2007, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#include <string.h>

#include "array.h"

struct array_ {
  size_t el_sz;
  size_t alloc;
  size_t used;
  char  *data;
};

array_t *array_alloc(size_t alloc, size_t el_sz)
{
  array_t *array;

  array = malloc(sizeof(*array));
  if (array) {
    array->alloc = 0;
    array->used  = 0;
    array->el_sz = el_sz;
    array->data  = 0;
    if (alloc) {
      array->data = malloc(el_sz * alloc);
      if (array->data) {
        array->alloc = alloc;
      }
    }
  }
  return array;
}

void array_free(array_t *array)
{
  if (array) {
    free(array->data);
    free(array);
  }
}

void *array_get(const array_t *array, size_t n)
{
  return (array && (n < array->used))
    ? array->data + n * array->el_sz
    : 0;
}

void *array_set(array_t *array, size_t n, const void *el)
{
  void *data;

  data = (array && (n < array->used))
    ? array->data + n * array->el_sz
    : 0;
  if (data && el) {
    memcpy(array->data + n * array->el_sz, el, array->el_sz);
  }
  return data;
}

void *array_append(array_t *array, void *el)
{
  if (array && (array->used == array->alloc)) {
    void  *tmp;
    size_t alloc;

    alloc = (array->alloc) ? 2 * array->alloc : 32;
    tmp   = realloc(array->data, alloc * array->el_sz);
    if (tmp) {
      array->data  = tmp;
      array->alloc = alloc;
    }
  }
  if (array->used < array->alloc) {
    array->used++;
  }
  return array_set(array, array->used - 1, el);
}

size_t array_ct(const array_t *array)
{
  return (array) ? array->used : 0;
}

