/************************************************************
 **
 ** array.h : array handling
 **
 ** Copyright (c) 2007, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#ifndef array_h__
#define array_h__

#include <stdlib.h>

typedef struct array_ array_t;

array_t *array_alloc(size_t alloc, size_t el_sz);
void     array_free(array_t *array);
void    *array_get(const array_t *array, size_t n);
void    *array_set(array_t *array, size_t n, const void *el);
void    *array_append(array_t *array, void *el);
size_t   array_ct(const array_t *array);

#endif
/*
 * generate a typesafe array class. `name' is the array name. the
 * accessor functions will be name_*
 * the type will be name_t
 * the array will holds types of element
 */
#undef ARRAY_DEF
#ifdef ARRAY_DEFINE

#define ARRAY_DEF(name, element)                                  \
  typedef array_t name##_t;                                       \
  name##_t *name##_alloc(size_t ct)                               \
    { return (name##_t *) array_alloc(ct, sizeof(element)); }     \
  void name##_free(name##_t *array)                               \
    { array_free((array_t *) array); }                            \
  element *name##_entry_append(name##_t *array, element *el)      \
    { return array_append((array_t *) array, el); }               \
  element *name##_entry_get(const name##_t *array, size_t n)      \
    { return (element *) array_get((const array_t *) array, n); } \
  element *name##_entry_set(name##_t *array, size_t n,            \
    const element *el)                                            \
    { return (element *) array_set((array_t *) array, n, el); }   \
  size_t name##_entry_ct(const name##_t *array)                   \
    { return array_ct(array); }
#else

#define ARRAY_DEF(name, element)                                  \
  typedef array_t name##_t;                                       \
  name##_t *name##_alloc(size_t ct);                              \
  void name##_free(name##_t *array);                              \
  element *name##_entry_append(name##_t *array, element *el);     \
  element *name##_entry_get(const name##_t *array, size_t n);     \
  element *name##_entry_set(name##_t *array, size_t n,            \
    const element *el);                                           \
  size_t name##_entry_ct(const name##_t *array);

#endif


