/**********************************************************
 **
 ** operator.c : manipulators for operator_t
 **
 ** Copyright (c) 2004-2005, Kyle A. York
 ** All rights reserved
 **
 ***********************************************************/
#include "operator.h"

/*
 * NAME
 *   operator_is_unary
 *
 * DESCRIPTION
 *   determine if an operator is a unary op
 *
 * PARAMETERS
 *   op : operator
 *
 * RETURN
 *   0 : operator is not unary
 *   1 : operator is unary
 *
 * NOTES
 */
boolean_t operator_is_unary(operator_t op)
{
  boolean_t rc;

  rc = boolean_false;
  switch (op) {
    case operator_null:
    case operator_add:
    case operator_sub:
    case operator_mul:
    case operator_div:
    case operator_mod:
    case operator_lt:
    case operator_le:
    case operator_eq:
    case operator_ne:
    case operator_ge:
    case operator_gt:
    case operator_andl:
    case operator_orl:
    case operator_andb:
    case operator_orb:
    case operator_xorb:
    case operator_shift_left:
    case operator_shift_right:
    case operator_shift_right_arithmetic:
    case operator_assign:
      break;
    case operator_logical:
    case operator_notl:
    case operator_cmpb:
    case operator_neg:
    case operator_incr:
    case operator_decr:
    case operator_reference:
      rc = boolean_true;
      break;
  }
  return rc;
}

boolean_t operator_is_assign(operator_t op)
{
  boolean_t rc;

  rc = boolean_false;
  switch (op) {
    case operator_null:
    case operator_add:
    case operator_sub:
    case operator_mul:
    case operator_div:
    case operator_mod:
    case operator_lt:
    case operator_le:
    case operator_eq:
    case operator_ne:
    case operator_ge:
    case operator_gt:
    case operator_andl:
    case operator_orl:
    case operator_andb:
    case operator_orb:
    case operator_xorb:
    case operator_shift_left:
    case operator_shift_right:
    case operator_shift_right_arithmetic:
    case operator_logical:
    case operator_notl:
    case operator_cmpb:
    case operator_neg:
    case operator_incr:
    case operator_decr:
    case operator_reference:
      break;
    case operator_assign:
      rc = boolean_true;
      break;
  }
  return rc;
}

boolean_t operator_is_binary(operator_t op)
{
  return !(operator_is_unary(op) || operator_is_assign(op));
}

boolean_t operator_is_logical(operator_t op)
{
  boolean_t rc;

  rc = boolean_false;
  switch (op) {
    case operator_null:
    case operator_add:
    case operator_sub:
    case operator_mul:
    case operator_div:
    case operator_mod:
    case operator_lt:
    case operator_le:
    case operator_eq:
    case operator_ne:
    case operator_ge:
    case operator_gt:
    case operator_andb:
    case operator_orb:
    case operator_xorb:
    case operator_shift_left:
    case operator_shift_right:
    case operator_shift_right_arithmetic:
    case operator_cmpb:
    case operator_neg:
    case operator_incr:
    case operator_decr:
    case operator_assign:
    case operator_reference:
      break;
    case operator_andl:
    case operator_orl:
    case operator_logical:
    case operator_notl:
      rc = boolean_true;
      break;
  }
  return rc;
}

boolean_t operator_is_relation(operator_t op)
{
  boolean_t rc;

  rc = boolean_false;
  switch (op) {
    case operator_null:
    case operator_add:
    case operator_sub:
    case operator_mul:
    case operator_div:
    case operator_mod:
    case operator_andl:
    case operator_orl:
    case operator_andb:
    case operator_orb:
    case operator_xorb:
    case operator_shift_left:
    case operator_shift_right:
    case operator_shift_right_arithmetic:
    case operator_logical:
    case operator_notl:
    case operator_cmpb:
    case operator_neg:
    case operator_incr:
    case operator_decr:
    case operator_assign:
    case operator_reference:
      break;
    case operator_lt:
    case operator_le:
    case operator_eq:
    case operator_ne:
    case operator_ge:
    case operator_gt:
      rc = boolean_true;
      break;
  }
  return rc;
}

boolean_t operator_is_commutative(operator_t op)
{
  boolean_t rc;

  rc = boolean_false;
  switch (op) {
    case operator_null:
    case operator_sub:
    case operator_div:
    case operator_mod:
    case operator_shift_left:
    case operator_shift_right:
    case operator_shift_right_arithmetic:
    case operator_logical:
    case operator_notl:
    case operator_cmpb:
    case operator_neg:
    case operator_incr:
    case operator_decr:
    case operator_assign:
    case operator_lt:
    case operator_le:
    case operator_ge:
    case operator_gt:
    case operator_reference:
      break;
    case operator_add:
    case operator_mul:
    case operator_andl:
    case operator_orl:
    case operator_andb:
    case operator_orb:
    case operator_xorb:
    case operator_eq:
    case operator_ne:
      rc = boolean_true;
      break;
  }
  return rc;
}

