/************************************************************
 **
 ** types.h : common type definitions
 **
 ** Copyright (c) 2005, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#ifndef types_h__
#define types_h__

#include "ctype.h"

#if 0
typedef unsigned char uchar;
typedef unsigned long ulong;
#else
#undef uchar
#undef ushort
#undef ulong
#define uchar  unsigned char
#define ushort unsigned short
#define ulong  unsigned long
#endif

typedef unsigned short boolean_t;
/* nb : *never* compare against boolean_true! */
enum {boolean_false, boolean_true};

typedef unsigned long  flag_t;  /* flags             */
typedef unsigned short refct_t; /* reference counter */
typedef unsigned short ctr_t;   /* usage counter     */

typedef enum result_ {
  result_ok = 0,    /* no error              */
  result_memory,    /* out of memory         */
  result_syntax,    /* syntax error          */
  result_not_found,
  result_divide_by_zero,
  result_exists,
  result_range,
  result_internal,  /* invalid parameter passed to a function */
  result_invalid
} result_t;

typedef enum ctr_bump_ {
  ctr_bump_incr = 0,
  ctr_bump_decr
} ctr_bump_t;

#define TOLOWER(ch)  tolower((unsigned char) ch)
#define ISSPACE(ch)  isspace((unsigned char) ch)
#define ISALPHA(ch)  isalpha((unsigned char) ch)
#define ISDIGIT(ch)  isdigit((unsigned char) ch)
#define ISXDIGIT(ch) isxdigit((unsigned char) ch)
#define ISOCTDIGIT(x) (('0' == (x)) \
                    || ('1' == (x)) \
                    || ('2' == (x)) \
                    || ('3' == (x)) \
                    || ('4' == (x)) \
                    || ('5' == (x)) \
                    || ('6' == (x)) \
                    || ('7' == (x)))
#define COUNT(x) (sizeof(x)/sizeof(x[0]))

/* note to the compiler that a parameter isn't used */
#define UNUSED(x) ((void) (x))

#endif /* types_h__ */

