/************************************************************
 **
 ** pic_cmdo.c : pic cmd optimization definitions
 **
 ** Copyright (c) 2005, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#include "../libcore/value.h"
#include "../libcore/cmd_op.h"
#include "../libcore/cmd_brch.h"
#include "pic_cmdo.h"


/* this occurs after all pfile optimization, but before variable
 * definition
 *
 * currently, it looks for
 *   tmp = expr
 *   branch condition tmp --> x
 * and removes tmp from (tmp = relational)
 */ 
void pic_cmd_optimize(pfile_t *pf, cmd_t *cmd_head)
{
#if 1
  cmd_t cmd;

  cmd = cmd_next_exec_get(*cmd_head);
  while (cmd) {
    cmd_t cmd_next;
    
    cmd_next = cmd_next_exec_get(cmd_link_get(cmd));
    if ((operator_is_relation(cmd_optype_get(cmd))
          || (operator_assign == cmd_optype_get(cmd))
          || (operator_logical == cmd_optype_get(cmd))
          || (operator_notl == cmd_optype_get(cmd))
          || (operator_cmpb == cmd_optype_get(cmd)))
        && value_is_temp(cmd_opdst_get(cmd))
        && value_is_same(cmd_opdst_get(cmd), cmd_brval_get(cmd_next))
        && (cmd_branchcond_none != cmd_brcond_get(cmd_next))) {
#if 0
      printf("cmd=0x%p op=%u\n", (void *) cmd, cmd_optype_get(cmd));
      printf("...");
      value_dump(cmd_opdst_get(cmd), stdout);
      printf("\n");
#endif
      cmd_opdst_set(cmd, VALUE_NONE);
      cmd_brval_set(cmd_next, VALUE_NONE);
    }
    cmd = cmd_next;
  }
#endif
}

