/************************************************************
 **
 ** pic_opco.h : PIC opcode declarations
 **
 ** Copyright (c) 2004-2005, Kyle A. York
 ** All rights reserved
 **
 ************************************************************/
#ifndef pic_opco_h__
#define pic_opco_h__

/*
 * d = 0 (W) 1 (F)
 * a = 0 (access) 1 (BSR)
 * b = bit (0 <= b <= 7)
 * r = relative offset -128 <= r <= 127
 * R = relative offset -1024 <= R <= 1023
 * s = 0 (no update) 1 (save W/Status/BSR)
 * k = absolute address or value
 * x = doesn't matter
 * n = 0 (no change) 1 (post incr) 2 (post decr) 3 (pre incr)
 */
typedef enum {
  pic_opcode_org,    /* ORG xxxx */
  pic_opcode_end,    /* END      */
  pic_opcode_none,   /* no code here */
  /* literal instructions on W */

  /* pic_instr_append_w_k  */
  /* pic_instr_append_w_kn */
  pic_opcode_addlw,  /* w = k + w */
  pic_opcode_andlw,  /* w = k & w */
  pic_opcode_iorlw,  /* w = k | w */
  pic_opcode_movlw,  /* w = k     */
  pic_opcode_mullw,  /* w * l --> PRODH:PRODL */
  pic_opcode_retlw,
  pic_opcode_sublw,  /* w = k - w */
  pic_opcode_xorlw,  /* w = k ^ w */
  pic_opcode_tris,   /* w --> tris; k must be 6; backward compat only! */

  /* file register with destination */
  /* pic_instr_append_f_d   */
  /* pic_instr_append_reg_d */
  pic_opcode_addwf,  /* f  + w --> d                 */
  pic_opcode_addwfc, /* 0010 00da ffff ffff */
  pic_opcode_andwf,  /* f  & w --> d                 */
  pic_opcode_comf,   /* ~f     --> d                 */
  pic_opcode_decf,   /* f - 1  --> d                 */
  pic_opcode_dcfsnz, /* 0100 11da ffff ffff */
  pic_opcode_decfsz, /* f - 1  --> d, skip next if 0 */
  pic_opcode_incf,   /* f + 1  --> d                 */
  pic_opcode_incfsz, /* f + 1  --> d, skip next if 0 */
  pic_opcode_infsnz, /* 0100 10da ffff ffff */
  pic_opcode_iorwf,  /* f  | w --> d                 */
  pic_opcode_movf,   /* f      --> d                 */
  pic_opcode_rlf,    /* f << 1 --> d                 */
  pic_opcode_rlcf,   /* f << 1 --> d                 */
  pic_opcode_rlncf,  /* 0100 01da ffff ffff */
  pic_opcode_rrf,    /* f >> 1 --> d                 */
  pic_opcode_rrncf,  /* 0100 00da ffff ffff */
  pic_opcode_subfwb, /* 0101 01da ffff ffff */
  pic_opcode_subwf,  /* f  - w --> d                 */
  pic_opcode_subwfb,
  pic_opcode_swapf,  /* swap nibbles in f --> d      */
  pic_opcode_xorwf,  /* f  ^ w --> d                 */
  /* filre register instructions w/o dst */
  /* pic_instr_append_f   */
  /* pic_instr_append_reg */
  pic_opcode_clrf,   /* f = 0                        */
  pic_opcode_cpfseq, /* 0110 001a ffff ffff */
  pic_opcode_cpfsgt, /* 0110 010a ffff ffff */
  pic_opcode_cpfslt, /* 0110 000a ffff ffff */
  pic_opcode_movwf,  /* 0110 111a ffff ffff */
  pic_opcode_mulwf,  /* 0000 001a ffff ffff */
  pic_opcode_negf,   /* 0110 110a ffff ffff */
  pic_opcode_setf,   /* 0110 100a ffff ffff */
  pic_opcode_tstfsz, /* 0110 011a ffff ffff */
  /* bit instructions */
  /* pic_instr_append_f_b      */
  /* pic_instr_append_reg_flag */
  /* pic_instr_append_f_bn     */
  /* pic_instr_append_reg_bn   */
  pic_opcode_bcf,    /* f, b -- bit clear */
  pic_opcode_bsf,    /* f, b -- bit set   */
  pic_opcode_btfsc,  /* f, b -- bit test, skip next if clear */
  pic_opcode_btfss,  /* f, b -- bit test, skip next if set   */
  pic_opcode_btg,    /* f, b -- bit toggle */
  /* relative branch instructions -128...127 */
  pic_opcode_bc,     /* 1110 0010 rrrr rrrr */
  pic_opcode_bn,     /* 1110 0110 rrrr rrrr */
  pic_opcode_bnc,    /* 1110 0011 rrrr rrrr */
  pic_opcode_bnn,    /* 1110 0111 rrrr rrrr */
  pic_opcode_bnov,   /* 1110 0101 rrrr rrrr */
  pic_opcode_bnz,    /* 1110 0001 rrrr rrrr */
  pic_opcode_bov,    /* 1110 0100 rrrr rrrr */
  pic_opcode_bz,     /* 1110 0000 rrrr rrrr */
  /* relative branch instruction */
  pic_opcode_bra,    /* 1101 0RRR RRRR RRRR */
  pic_opcode_rcall,  /* 1101 1RRR RRRR RRRR */
  /* long branch instructions */
  /* pic_instr_append_n */
  pic_opcode_call,   /* call n */
  pic_opcode_goto,   /* goto n */
  /* no operand instructions */
  /* pic_instr_append */
  pic_opcode_clrw,   /* w = 0     */
  pic_opcode_clrwdt,
  pic_opcode_daw,
  pic_opcode_nop,    /*                              */
  pic_opcode_option, /* w --> option */
  pic_opcode_pop,    /* 0000 0000 0000 0110 */
  pic_opcode_push,   /* 0000 0000 0000 0101 */
  pic_opcode_reset,  /* 0000 0000 1111 1111 */
  pic_opcode_return, /* return */
  pic_opcode_retfie, /* return from interrupt */
  pic_opcode_sleep,
  /* misc. instructions */
  pic_opcode_lfsr,   /* 1110 1110 00ff kkkk (11..8) */
                       /* 1111 0000 kkkk kkkk ( 7..0) */
  pic_opcode_movff,  /* 1100 ffff ffff ffff (src) */
                       /* 1111 ffff ffff ffff (dst) */
  pic_opcode_movlb,  /* 0000 0001 kkkk kkkk */
  pic_opcode_tblrd,  /* 0000 0000 0000 10nn */
  pic_opcode_tblwt,  /* 0000 0000 0000 11nn */
  /* pseudo-ops to make life easier, translation in comments */
  pic_opcode_datalo_set, /* bsf _status, _rp0 */
  pic_opcode_datalo_clr, /* bcf _status, _rp0 */
  pic_opcode_datahi_set, /* bsf _status, _rp1 */
  pic_opcode_datahi_clr, /* bcf _status, _rp1 */
  pic_opcode_irp_set,    /* bsf _status, _irp */
  pic_opcode_irp_clr,    /* bcf _status, _irp */
  pic_opcode_branchlo_set, /* bsf _pclath, 3 */
  pic_opcode_branchlo_clr, /* bcf _pclath, 3 */
  pic_opcode_branchlo_nop, /* nop */
  pic_opcode_branchhi_set, /* bsf _pclath, 4 */
  pic_opcode_branchhi_clr, /* bcf _pclath, 4 */
  pic_opcode_branchhi_nop, /* nop */
  pic_opcode_db            /* db yy,xx */
} pic_opcode_t;

typedef enum {
  pic_optype_none = 0, /* no parameters */
  pic_optype_f,        /* opdst = none, val = f, val2 = none, label = none */
  pic_optype_f_d,      /* opdst = w/f,  val = f, val2 = none, label = none */
  pic_optype_f_b,      /* opdst = none, val = f, val2 = bit,  label = none */
  pic_optype_n,        /* opdst = none, val = none, val2 = #, label = none */
  pic_optype_k,        /* opdst = none, val = none, val2 = none, label = k */
  pic_optype_tris,     /* opdst = none, val = none, val2 = t, label = none */
  pic_optype_db
#if 0
  pic_optype_macro,
#endif
} pic_optype_t;

typedef enum {
  pic_opdst_none, /* no dst */
  pic_opdst_w,
  pic_opdst_f
} pic_opdst_t;

typedef enum {
  pic_tblptr_change_none,     /* no change      */
  pic_tblptr_change_post_inc, /* post increment */
  pic_tblptr_change_post_dec, /* post decrement */
  pic_tblptr_change_pre_inc   /* pre increment  */
} pic_tblptr_change_t;

#endif /* pic_opco_h__ */

